/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.java.swing.SwingUtilities3;
import java.applet.Applet;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.SubRegionShowable;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.hw.ExtendedBufferCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BufferStrategyPaintManager
extends RepaintManager.PaintManager {
    private static Method COMPONENT_CREATE_BUFFER_STRATEGY_METHOD;
    private static Method COMPONENT_GET_BUFFER_STRATEGY_METHOD;
    private static final Logger LOGGER;
    private ArrayList<BufferInfo> bufferInfos = new ArrayList(1);
    private boolean painting;
    private boolean showing;
    private int accumulatedX;
    private int accumulatedY;
    private int accumulatedMaxX;
    private int accumulatedMaxY;
    private JComponent rootJ;
    private Container root;
    private int xOffset;
    private int yOffset;
    private Graphics bsg;
    private BufferStrategy bufferStrategy;
    private BufferInfo bufferInfo;
    private boolean disposeBufferOnEnd;

    private static Method getGetBufferStrategyMethod() {
        if (COMPONENT_GET_BUFFER_STRATEGY_METHOD == null) {
            BufferStrategyPaintManager.getMethods();
        }
        return COMPONENT_GET_BUFFER_STRATEGY_METHOD;
    }

    private static Method getCreateBufferStrategyMethod() {
        if (COMPONENT_CREATE_BUFFER_STRATEGY_METHOD == null) {
            BufferStrategyPaintManager.getMethods();
        }
        return COMPONENT_CREATE_BUFFER_STRATEGY_METHOD;
    }

    private static void getMethods() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block4: {
                    try {
                        COMPONENT_CREATE_BUFFER_STRATEGY_METHOD = Component.class.getDeclaredMethod("createBufferStrategy", Integer.TYPE, BufferCapabilities.class);
                        COMPONENT_CREATE_BUFFER_STRATEGY_METHOD.setAccessible(true);
                        COMPONENT_GET_BUFFER_STRATEGY_METHOD = Component.class.getDeclaredMethod("getBufferStrategy", new Class[0]);
                        COMPONENT_GET_BUFFER_STRATEGY_METHOD.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        assert (false);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                return null;
            }
        });
    }

    BufferStrategyPaintManager() {
    }

    @Override
    protected void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList;
                BufferStrategyPaintManager bufferStrategyPaintManager = BufferStrategyPaintManager.this;
                synchronized (bufferStrategyPaintManager) {
                    while (BufferStrategyPaintManager.this.showing) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    arrayList = BufferStrategyPaintManager.this.bufferInfos;
                    BufferStrategyPaintManager.this.bufferInfos = null;
                }
                BufferStrategyPaintManager.this.dispose(arrayList);
            }
        });
    }

    private void dispose(List<BufferInfo> list) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "BufferStrategyPaintManager disposed", new RuntimeException());
        }
        if (list != null) {
            for (BufferInfo bufferInfo : list) {
                bufferInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean show(Container container, int n, int n2, int n3, int n4) {
        block14: {
            block15: {
                BufferStrategyPaintManager bufferStrategyPaintManager;
                boolean bl;
                Object object = this;
                synchronized (object) {
                    if (this.painting) {
                        return false;
                    }
                    this.showing = true;
                }
                try {
                    BufferStrategy bufferStrategy;
                    object = this.getBufferInfo(container);
                    if (object == null || !((BufferInfo)object).isInSync() || (bufferStrategy = ((BufferInfo)object).getBufferStrategy(false)) == null) break block14;
                    SubRegionShowable subRegionShowable = (SubRegionShowable)((Object)bufferStrategy);
                    boolean bl2 = ((BufferInfo)object).getPaintAllOnExpose();
                    ((BufferInfo)object).setPaintAllOnExpose(false);
                    if (!subRegionShowable.showIfNotLost(n, n2, n + n3, n2 + n4)) break block15;
                    bl = !bl2;
                    Object var12_12 = null;
                    bufferStrategyPaintManager = this;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    BufferStrategyPaintManager bufferStrategyPaintManager2 = this;
                    synchronized (bufferStrategyPaintManager2) {
                        this.showing = false;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (bufferStrategyPaintManager) {
                    this.showing = false;
                    this.notifyAll();
                }
                return bl;
            }
            this.bufferInfo.setContentsLostDuringExpose(true);
        }
        Object var12_13 = null;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.showing = false;
            this.notifyAll();
        }
        return false;
    }

    @Override
    public boolean paint(JComponent jComponent, JComponent jComponent2, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.prepare(jComponent, true, n, n2, n3, n4)) {
            if (graphics instanceof SunGraphics2D && ((SunGraphics2D)graphics).getDestination() == this.root) {
                int n5 = ((SunGraphics2D)this.bsg).constrainX;
                int n6 = ((SunGraphics2D)this.bsg).constrainY;
                if (n5 != 0 || n6 != 0) {
                    this.bsg.translate(-n5, -n6);
                }
                ((SunGraphics2D)this.bsg).constrain(this.xOffset + n5, this.yOffset + n6, n + n3, n2 + n4);
                this.bsg.setClip(n, n2, n3, n4);
                jComponent.paintToOffscreen(this.bsg, n, n2, n3, n4, n + n3, n2 + n4);
                this.accumulate(this.xOffset + n, this.yOffset + n2, n3, n4);
                return true;
            }
            this.bufferInfo.setInSync(false);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("prepare failed");
        }
        return super.paint(jComponent, jComponent2, graphics, n, n2, n3, n4);
    }

    @Override
    public void copyArea(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.prepare(jComponent, false, 0, 0, 0, 0) && this.bufferInfo.isInSync()) {
            if (bl) {
                Rectangle rectangle = jComponent.getVisibleRect();
                int n7 = this.xOffset + n;
                int n8 = this.yOffset + n2;
                this.bsg.clipRect(this.xOffset + rectangle.x, this.yOffset + rectangle.y, rectangle.width, rectangle.height);
                this.bsg.copyArea(n7, n8, n3, n4, n5, n6);
            } else {
                this.bsg.copyArea(this.xOffset + n, this.yOffset + n2, n3, n4, n5, n6);
            }
            this.accumulate(n + this.xOffset + n5, n2 + this.yOffset + n6, n3, n4);
        } else {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("copyArea: prepare failed or not in sync");
            }
            if (!this.flushAccumulatedRegion()) {
                this.rootJ.repaint();
            } else {
                super.copyArea(jComponent, graphics, n, n2, n3, n4, n5, n6, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginPaint() {
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.painting = true;
            while (this.showing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("beginPaint");
        }
        this.resetAccumulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endPaint() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("endPaint: region " + this.accumulatedX + " " + this.accumulatedY + " " + this.accumulatedMaxX + " " + this.accumulatedMaxY);
        }
        if (this.painting && !this.flushAccumulatedRegion()) {
            if (!this.isRepaintingRoot()) {
                this.repaintRoot(this.rootJ);
            } else {
                this.resetDoubleBufferPerWindow();
                this.rootJ.repaint();
            }
        }
        BufferInfo bufferInfo = null;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.painting = false;
            if (this.disposeBufferOnEnd) {
                this.disposeBufferOnEnd = false;
                bufferInfo = this.bufferInfo;
                this.bufferInfos.remove(bufferInfo);
            }
        }
        if (bufferInfo != null) {
            bufferInfo.dispose();
        }
    }

    private boolean flushAccumulatedRegion() {
        boolean bl = true;
        if (this.accumulatedX != Integer.MAX_VALUE) {
            SubRegionShowable subRegionShowable = (SubRegionShowable)((Object)this.bufferStrategy);
            boolean bl2 = this.bufferStrategy.contentsLost();
            if (!bl2) {
                subRegionShowable.show(this.accumulatedX, this.accumulatedY, this.accumulatedMaxX, this.accumulatedMaxY);
                bl2 = this.bufferStrategy.contentsLost();
            }
            if (bl2) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("endPaint: contents lost");
                }
                this.bufferInfo.setInSync(false);
                bl = false;
            }
        }
        this.resetAccumulated();
        return bl;
    }

    private void resetAccumulated() {
        this.accumulatedX = Integer.MAX_VALUE;
        this.accumulatedY = Integer.MAX_VALUE;
        this.accumulatedMaxX = 0;
        this.accumulatedMaxY = 0;
    }

    @Override
    public void doubleBufferingChanged(final JRootPane jRootPane) {
        if (!(jRootPane.isDoubleBuffered() && jRootPane.getUseTrueDoubleBuffering() || jRootPane.getParent() == null)) {
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        BufferStrategyPaintManager.this.doubleBufferingChanged0(jRootPane);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                this.doubleBufferingChanged0(jRootPane);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doubleBufferingChanged0(JRootPane jRootPane) {
        BufferInfo bufferInfo;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            while (this.showing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            bufferInfo = this.getBufferInfo(jRootPane.getParent());
            if (this.painting && this.bufferInfo == bufferInfo) {
                this.disposeBufferOnEnd = true;
                bufferInfo = null;
            } else if (bufferInfo != null) {
                this.bufferInfos.remove(bufferInfo);
            }
        }
        if (bufferInfo != null) {
            bufferInfo.dispose();
        }
    }

    private boolean prepare(JComponent jComponent, boolean bl, int n, int n2, int n3, int n4) {
        if (this.bsg != null) {
            this.bsg.dispose();
            this.bsg = null;
        }
        this.bufferStrategy = null;
        if (this.fetchRoot(jComponent)) {
            boolean bl2 = false;
            BufferInfo bufferInfo = this.getBufferInfo(this.root);
            if (bufferInfo == null) {
                bl2 = true;
                bufferInfo = new BufferInfo(this.root);
                this.bufferInfos.add(bufferInfo);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("prepare: new BufferInfo: " + this.root);
                }
            }
            this.bufferInfo = bufferInfo;
            if (!bufferInfo.hasBufferStrategyChanged()) {
                this.bufferStrategy = bufferInfo.getBufferStrategy(true);
                if (this.bufferStrategy != null) {
                    this.bsg = this.bufferStrategy.getDrawGraphics();
                    if (this.bufferStrategy.contentsRestored()) {
                        bl2 = true;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("prepare: contents restored in prepare");
                        }
                    }
                } else {
                    return false;
                }
                if (bufferInfo.getContentsLostDuringExpose()) {
                    bl2 = true;
                    bufferInfo.setContentsLostDuringExpose(false);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("prepare: contents lost on expose");
                    }
                }
                if (bl && jComponent == this.rootJ && n == 0 && n2 == 0 && jComponent.getWidth() == n3 && jComponent.getHeight() == n4) {
                    bufferInfo.setInSync(true);
                } else if (bl2) {
                    bufferInfo.setInSync(false);
                    if (!this.isRepaintingRoot()) {
                        this.repaintRoot(this.rootJ);
                    } else {
                        this.resetDoubleBufferPerWindow();
                    }
                }
                return this.bufferInfos != null;
            }
        }
        return false;
    }

    private boolean fetchRoot(JComponent jComponent) {
        boolean bl = false;
        this.rootJ = jComponent;
        this.root = jComponent;
        this.yOffset = 0;
        this.xOffset = 0;
        while (this.root != null && !(this.root instanceof Window) && !(this.root instanceof Applet)) {
            this.xOffset += this.root.getX();
            this.yOffset += this.root.getY();
            this.root = this.root.getParent();
            if (this.root == null) continue;
            if (this.root instanceof JComponent) {
                this.rootJ = (JComponent)this.root;
                continue;
            }
            if (this.root.isLightweight()) continue;
            if (!bl) {
                bl = true;
                continue;
            }
            return false;
        }
        return this.root instanceof RootPaneContainer && this.rootJ instanceof JRootPane && this.rootJ.isDoubleBuffered() && ((JRootPane)this.rootJ).getUseTrueDoubleBuffering();
    }

    private void resetDoubleBufferPerWindow() {
        if (this.bufferInfos != null) {
            this.dispose(this.bufferInfos);
            this.bufferInfos = null;
            this.repaintManager.setPaintManager(null);
        }
    }

    private BufferInfo getBufferInfo(Container container) {
        for (int i = this.bufferInfos.size() - 1; i >= 0; --i) {
            BufferInfo bufferInfo = this.bufferInfos.get(i);
            Container container2 = bufferInfo.getRoot();
            if (container2 == null) {
                this.bufferInfos.remove(i);
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer("BufferInfo pruned, root null");
                continue;
            }
            if (container2 != container) continue;
            return bufferInfo;
        }
        return null;
    }

    private void accumulate(int n, int n2, int n3, int n4) {
        this.accumulatedX = Math.min(n, this.accumulatedX);
        this.accumulatedY = Math.min(n2, this.accumulatedY);
        this.accumulatedMaxX = Math.max(this.accumulatedMaxX, n + n3);
        this.accumulatedMaxY = Math.max(this.accumulatedMaxY, n2 + n4);
    }

    static {
        LOGGER = Logger.getLogger("javax.swing.BufferStrategyPaintManager");
    }

    private class BufferInfo
    extends ComponentAdapter
    implements WindowListener {
        private WeakReference<BufferStrategy> weakBS;
        private WeakReference<Container> root;
        private boolean inSync;
        private boolean contentsLostDuringExpose;
        private boolean paintAllOnExpose;

        public BufferInfo(Container container) {
            this.root = new WeakReference<Container>(container);
            container.addComponentListener(this);
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
            }
        }

        public void setPaintAllOnExpose(boolean bl) {
            this.paintAllOnExpose = bl;
        }

        public boolean getPaintAllOnExpose() {
            return this.paintAllOnExpose;
        }

        public void setContentsLostDuringExpose(boolean bl) {
            this.contentsLostDuringExpose = bl;
        }

        public boolean getContentsLostDuringExpose() {
            return this.contentsLostDuringExpose;
        }

        public void setInSync(boolean bl) {
            this.inSync = bl;
        }

        public boolean isInSync() {
            return this.inSync;
        }

        public Container getRoot() {
            return this.root == null ? null : (Container)this.root.get();
        }

        public BufferStrategy getBufferStrategy(boolean bl) {
            BufferStrategy bufferStrategy;
            BufferStrategy bufferStrategy2 = bufferStrategy = this.weakBS == null ? null : (BufferStrategy)this.weakBS.get();
            if (bufferStrategy == null && bl) {
                bufferStrategy = this.createBufferStrategy();
                if (bufferStrategy != null) {
                    this.weakBS = new WeakReference<BufferStrategy>(bufferStrategy);
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("getBufferStrategy: created bs: " + bufferStrategy);
                }
            }
            return bufferStrategy;
        }

        public boolean hasBufferStrategyChanged() {
            Container container = this.getRoot();
            if (container != null) {
                BufferStrategy bufferStrategy;
                BufferStrategy bufferStrategy2;
                block11: {
                    bufferStrategy2 = null;
                    bufferStrategy = null;
                    bufferStrategy2 = this.getBufferStrategy(false);
                    if (container instanceof Window) {
                        bufferStrategy = ((Window)container).getBufferStrategy();
                    } else {
                        try {
                            bufferStrategy = (BufferStrategy)BufferStrategyPaintManager.getGetBufferStrategyMethod().invoke(container, new Object[0]);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            assert (false);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            assert (false);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if ($assertionsDisabled) break block11;
                            throw new AssertionError();
                        }
                    }
                }
                if (bufferStrategy != bufferStrategy2) {
                    if (bufferStrategy2 != null) {
                        bufferStrategy2.dispose();
                    }
                    this.weakBS = null;
                    return true;
                }
            }
            return false;
        }

        private BufferStrategy createBufferStrategy() {
            Container container = this.getRoot();
            if (container == null) {
                return null;
            }
            BufferStrategy bufferStrategy = null;
            if (SwingUtilities3.isVsyncRequested(container)) {
                bufferStrategy = this.createBufferStrategy(container, true);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("createBufferStrategy: using vsynced strategy");
                }
            }
            if (bufferStrategy == null) {
                bufferStrategy = this.createBufferStrategy(container, false);
            }
            if (!(bufferStrategy instanceof SubRegionShowable)) {
                bufferStrategy = null;
            }
            return bufferStrategy;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private BufferStrategy createBufferStrategy(Container container, boolean bl) {
            BufferCapabilities bufferCapabilities = bl ? new ExtendedBufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED, ExtendedBufferCapabilities.VSyncType.VSYNC_ON) : new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), null);
            BufferStrategy bufferStrategy = null;
            if (container instanceof Applet) {
                try {
                    BufferStrategyPaintManager.getCreateBufferStrategyMethod().invoke(container, 2, bufferCapabilities);
                    return (BufferStrategy)BufferStrategyPaintManager.getGetBufferStrategyMethod().invoke(container, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!LOGGER.isLoggable(Level.FINER)) return bufferStrategy;
                    LOGGER.log(Level.FINER, "createBufferStratety failed", invocationTargetException);
                    return bufferStrategy;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    assert (false);
                    return bufferStrategy;
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                    return bufferStrategy;
                }
            } else {
                try {
                    ((Window)container).createBufferStrategy(2, bufferCapabilities);
                    return ((Window)container).getBufferStrategy();
                }
                catch (AWTException aWTException) {
                    if (!LOGGER.isLoggable(Level.FINER)) return bufferStrategy;
                    LOGGER.log(Level.FINER, "createBufferStratety failed", aWTException);
                }
            }
            return bufferStrategy;
        }

        public void dispose() {
            Container container = this.getRoot();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "disposed BufferInfo for: " + container);
            }
            if (container != null) {
                BufferStrategy bufferStrategy;
                container.removeComponentListener(this);
                if (container instanceof Window) {
                    ((Window)container).removeWindowListener(this);
                }
                if ((bufferStrategy = this.getBufferStrategy(false)) != null) {
                    bufferStrategy.dispose();
                }
            }
            this.root = null;
            this.weakBS = null;
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Container container = this.getRoot();
            if (container != null && container.isVisible()) {
                container.repaint();
            } else {
                this.setPaintAllOnExpose(true);
            }
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.setPaintAllOnExpose(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(WindowEvent windowEvent) {
            BufferStrategyPaintManager bufferStrategyPaintManager = BufferStrategyPaintManager.this;
            synchronized (bufferStrategyPaintManager) {
                while (BufferStrategyPaintManager.this.showing) {
                    try {
                        BufferStrategyPaintManager.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BufferStrategyPaintManager.this.bufferInfos.remove(this);
            }
            this.dispose();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

