/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.Name;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.output.Encoded;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.XMLStreamWriterOutput;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Base64Data;
import com.sun.xml.internal.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.internal.org.jvnet.fastinfoset.VocabularyApplicationData;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public final class FastInfosetStreamWriterOutput
extends XMLStreamWriterOutput {
    private final StAXDocumentSerializer fiout;
    private final Encoded[] localNames;
    private final TablesPerJAXBContext tables;

    public FastInfosetStreamWriterOutput(StAXDocumentSerializer stAXDocumentSerializer, JAXBContextImpl jAXBContextImpl) {
        super(stAXDocumentSerializer);
        this.fiout = stAXDocumentSerializer;
        this.localNames = jAXBContextImpl.getUTF8NameTable();
        VocabularyApplicationData vocabularyApplicationData = this.fiout.getVocabularyApplicationData();
        AppData appData = null;
        if (vocabularyApplicationData == null || !(vocabularyApplicationData instanceof AppData)) {
            appData = new AppData();
            this.fiout.setVocabularyApplicationData(appData);
        } else {
            appData = (AppData)vocabularyApplicationData;
        }
        TablesPerJAXBContext tablesPerJAXBContext = appData.contexts.get(jAXBContextImpl);
        if (tablesPerJAXBContext != null) {
            this.tables = tablesPerJAXBContext;
            this.tables.clearOrResetTables(stAXDocumentSerializer.getLocalNameIndex());
        } else {
            this.tables = new TablesPerJAXBContext(jAXBContextImpl, stAXDocumentSerializer.getLocalNameIndex());
            appData.contexts.put(jAXBContextImpl, this.tables);
        }
    }

    public void startDocument(XMLSerializer xMLSerializer, boolean bl, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws IOException, SAXException, XMLStreamException {
        super.startDocument(xMLSerializer, bl, nArray, namespaceContextImpl);
        if (bl) {
            this.fiout.initiateLowLevelWriting();
        }
    }

    public void endDocument(boolean bl) throws IOException, SAXException, XMLStreamException {
        super.endDocument(bl);
    }

    public void beginStartTag(Name name) throws IOException {
        this.fiout.writeLowLevelTerminationAndMark();
        if (this.nsContext.getCurrent().count() == 0) {
            int n = this.tables.elementIndexes[name.qNameIndex] - this.tables.indexOffset;
            if (n >= 0) {
                this.fiout.writeLowLevelStartElementIndexed(0, n);
            } else {
                this.tables.elementIndexes[name.qNameIndex] = this.fiout.getNextElementIndex() + this.tables.indexOffset;
                int n2 = this.nsUriIndex2prefixIndex[name.nsUriIndex];
                this.writeLiteral(60, name, this.nsContext.getPrefix(n2), this.nsContext.getNamespaceURI(n2));
            }
        } else {
            this.beginStartTagWithNamespaces(name);
        }
    }

    public void beginStartTagWithNamespaces(Name name) throws IOException {
        int n;
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        this.fiout.writeLowLevelStartNamespaces();
        for (n = element.count() - 1; n >= 0; --n) {
            String string = element.getNsUri(n);
            if (string.length() == 0 && element.getBase() == 1) continue;
            this.fiout.writeLowLevelNamespace(element.getPrefix(n), string);
        }
        this.fiout.writeLowLevelEndNamespaces();
        n = this.tables.elementIndexes[name.qNameIndex] - this.tables.indexOffset;
        if (n >= 0) {
            this.fiout.writeLowLevelStartElementIndexed(0, n);
        } else {
            this.tables.elementIndexes[name.qNameIndex] = this.fiout.getNextElementIndex() + this.tables.indexOffset;
            int n2 = this.nsUriIndex2prefixIndex[name.nsUriIndex];
            this.writeLiteral(60, name, this.nsContext.getPrefix(n2), this.nsContext.getNamespaceURI(n2));
        }
    }

    public void attribute(Name name, String string) throws IOException {
        this.fiout.writeLowLevelStartAttributes();
        int n = this.tables.attributeIndexes[name.qNameIndex] - this.tables.indexOffset;
        if (n >= 0) {
            this.fiout.writeLowLevelAttributeIndexed(n);
        } else {
            this.tables.attributeIndexes[name.qNameIndex] = this.fiout.getNextAttributeIndex() + this.tables.indexOffset;
            short s = name.nsUriIndex;
            if (s == -1) {
                this.writeLiteral(120, name, "", "");
            } else {
                int n2 = this.nsUriIndex2prefixIndex[s];
                this.writeLiteral(120, name, this.nsContext.getPrefix(n2), this.nsContext.getNamespaceURI(n2));
            }
        }
        this.fiout.writeLowLevelAttributeValue(string);
    }

    private void writeLiteral(int n, Name name, String string, String string2) throws IOException {
        int n2 = this.tables.localNameIndexes[name.localNameIndex] - this.tables.indexOffset;
        if (n2 < 0) {
            this.tables.localNameIndexes[name.localNameIndex] = this.fiout.getNextLocalNameIndex() + this.tables.indexOffset;
            this.fiout.writeLowLevelStartNameLiteral(n, string, this.localNames[name.localNameIndex].buf, string2);
        } else {
            this.fiout.writeLowLevelStartNameLiteral(n, string, n2, string2);
        }
    }

    public void endStartTag() throws IOException {
        this.fiout.writeLowLevelEndStartElement();
    }

    public void endTag(Name name) throws IOException {
        this.fiout.writeLowLevelEndElement();
    }

    public void endTag(int n, String string) throws IOException {
        this.fiout.writeLowLevelEndElement();
    }

    public void text(Pcdata pcdata, boolean bl) throws IOException {
        if (bl) {
            this.fiout.writeLowLevelText(" ");
        }
        if (!(pcdata instanceof Base64Data)) {
            int n = pcdata.length();
            if (n < this.buf.length) {
                pcdata.writeTo(this.buf, 0);
                this.fiout.writeLowLevelText(this.buf, n);
            } else {
                this.fiout.writeLowLevelText(pcdata.toString());
            }
        } else {
            Base64Data base64Data = (Base64Data)pcdata;
            this.fiout.writeLowLevelOctets(base64Data.get(), base64Data.getDataLen());
        }
    }

    public void text(String string, boolean bl) throws IOException {
        if (bl) {
            this.fiout.writeLowLevelText(" ");
        }
        this.fiout.writeLowLevelText(string);
    }

    public void beginStartTag(int n, String string) throws IOException {
        boolean bl;
        this.fiout.writeLowLevelTerminationAndMark();
        int n2 = 0;
        if (this.nsContext.getCurrent().count() > 0) {
            NamespaceContextImpl.Element element = this.nsContext.getCurrent();
            this.fiout.writeLowLevelStartNamespaces();
            for (int i = element.count() - 1; i >= 0; --i) {
                String string2 = element.getNsUri(i);
                if (string2.length() == 0 && element.getBase() == 1) continue;
                this.fiout.writeLowLevelNamespace(element.getPrefix(i), string2);
            }
            this.fiout.writeLowLevelEndNamespaces();
            n2 = 0;
        }
        if (!(bl = this.fiout.writeLowLevelStartElement(n2, this.nsContext.getPrefix(n), string, this.nsContext.getNamespaceURI(n)))) {
            this.tables.incrementMaxIndexValue();
        }
    }

    public void attribute(int n, String string, String string2) throws IOException {
        this.fiout.writeLowLevelStartAttributes();
        boolean bl = n == -1 ? this.fiout.writeLowLevelAttribute("", "", string) : this.fiout.writeLowLevelAttribute(this.nsContext.getPrefix(n), this.nsContext.getNamespaceURI(n), string);
        if (!bl) {
            this.tables.incrementMaxIndexValue();
        }
        this.fiout.writeLowLevelAttributeValue(string2);
    }

    static final class AppData
    implements VocabularyApplicationData {
        final Map<JAXBContext, TablesPerJAXBContext> contexts = new WeakHashMap<JAXBContext, TablesPerJAXBContext>();
        final Collection<TablesPerJAXBContext> collectionOfContexts = this.contexts.values();

        AppData() {
        }

        public void clear() {
            for (TablesPerJAXBContext tablesPerJAXBContext : this.collectionOfContexts) {
                tablesPerJAXBContext.requireClearTables();
            }
        }
    }

    static final class TablesPerJAXBContext {
        final int[] elementIndexes;
        final int[] attributeIndexes;
        final int[] localNameIndexes;
        int indexOffset;
        int maxIndex;
        boolean requiresClear;

        TablesPerJAXBContext(JAXBContextImpl jAXBContextImpl, int n) {
            this.elementIndexes = new int[jAXBContextImpl.getNumberOfElementNames()];
            this.attributeIndexes = new int[jAXBContextImpl.getNumberOfAttributeNames()];
            this.localNameIndexes = new int[jAXBContextImpl.getNumberOfLocalNames()];
            this.indexOffset = 1;
            this.maxIndex = n + this.elementIndexes.length + this.attributeIndexes.length;
        }

        public void requireClearTables() {
            this.requiresClear = true;
        }

        public void clearOrResetTables(int n) {
            if (this.requiresClear) {
                this.requiresClear = false;
                this.indexOffset += this.maxIndex;
                this.maxIndex = n + this.elementIndexes.length + this.attributeIndexes.length;
                if (this.indexOffset + this.maxIndex < 0) {
                    this.clearAll();
                }
            } else {
                this.maxIndex = n + this.elementIndexes.length + this.attributeIndexes.length;
                if (this.indexOffset + this.maxIndex < 0) {
                    this.resetAll();
                }
            }
        }

        private void clearAll() {
            this.clear(this.elementIndexes);
            this.clear(this.attributeIndexes);
            this.clear(this.localNameIndexes);
            this.indexOffset = 1;
        }

        private void clear(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
        }

        public void incrementMaxIndexValue() {
            ++this.maxIndex;
            if (this.indexOffset + this.maxIndex < 0) {
                this.resetAll();
            }
        }

        private void resetAll() {
            this.clear(this.elementIndexes);
            this.clear(this.attributeIndexes);
            this.clear(this.localNameIndexes);
            this.indexOffset = 1;
        }

        private void reset(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = nArray[i] > this.indexOffset ? nArray[i] - this.indexOffset + 1 : 0;
            }
        }
    }
}

